<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\FlexApi\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;

/**
 * @property string[] $roles
 * @property string $url
 */
class UserRolesInstance extends InstanceResource {
    /**
     * Initialize the UserRolesInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     */
    public function __construct(Version $version, array $payload) {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'roles' => Values::array_get($payload, 'roles'),
            'url' => Values::array_get($payload, 'url'),
        ];

        $this->solution = [];
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     *
     * @return UserRolesContext Context for this UserRolesInstance
     */
    protected function proxy(): UserRolesContext {
        if (!$this->context) {
            $this->context = new UserRolesContext($this->version);
        }

        return $this->context;
    }

    /**
     * Fetch the UserRolesInstance
     *
     * @param array|Options $options Optional Arguments
     * @return UserRolesInstance Fetched UserRolesInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(array $options = []): UserRolesInstance {
        return $this->proxy()->fetch($options);
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name) {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.FlexApi.V1.UserRolesInstance ' . \implode(' ', $context) . ']';
    }
}